/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.dialogs;

import com.aptana.ui.dialogs.GenericInfoPopupDialog;
import com.aptana.ui.dialogs.Messages;
import com.aptana.ui.util.SWTUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class MinimizableWizardDialog
extends WizardDialog {
    private boolean hideOnFinish;
    private String infoTitle;
    private String infoMessage;
    private GenericInfoPopupDialog toast;

    public MinimizableWizardDialog(Shell parentShell, IWizard newWizard, String infoTitle, String infoMessage) {
        super(parentShell, newWizard);
        this.infoTitle = infoTitle;
        this.infoMessage = infoMessage;
    }

    public MinimizableWizardDialog(Shell parentShell, IWizard newWizard, boolean hideOnFinish, String infoTitle, String infoMessage) {
        this(parentShell, newWizard, infoTitle, infoMessage);
        this.hideOnFinish = hideOnFinish;
    }

    public void hidePressed() {
        if (this.hideOnFinish) {
            final Shell activeShell = this.getShell();
            this.toast = new GenericInfoPopupDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.infoTitle, this.infoMessage, new Runnable(){

                public void run() {
                    activeShell.setVisible(true);
                }
            });
            this.toast.open();
            activeShell.setVisible(false);
            activeShell.addListener(22, new Listener(){

                public void handleEvent(Event event) {
                    if (MinimizableWizardDialog.this.toast != null) {
                        MinimizableWizardDialog.this.toast.close();
                    }
                }
            });
            activeShell.addShellListener((ShellListener)new ShellAdapter(){

                public void shellClosed(ShellEvent e) {
                    if (MinimizableWizardDialog.this.toast != null) {
                        MinimizableWizardDialog.this.toast.close();
                    }
                }
            });
        }
    }

    public void enableHiding(boolean enabled) {
        if (this.hideOnFinish != enabled) {
            this.hideOnFinish = enabled;
            this.updateFinishButton(this.getButton(16));
        }
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button b = super.createButton(parent, id, label, defaultButton);
        if (this.hideOnFinish && id == 16) {
            this.updateFinishButton(b);
        }
        return b;
    }

    protected void finishPressed() {
        if (this.hideOnFinish) {
            this.hidePressed();
        } else {
            super.finishPressed();
        }
    }

    protected void updateFinishButton(Button button) {
        if (button != null) {
            button.setText(this.hideOnFinish ? Messages.MinimizableWizardDialog_hideLabel : IDialogConstants.FINISH_LABEL);
        }
    }

    public void disableButtonsOnFinish() {
        int[] ids;
        int[] nArray = ids = new int[]{15, 14};
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            Button button = this.getButton(id);
            if (!SWTUtils.isControlDisposed((Control)button)) {
                button.setEnabled(false);
            }
            ++n2;
        }
    }

    public GenericInfoPopupDialog getToastPopup() {
        return this.toast;
    }
}

